<div class="row">
	<div class="col-md-12">
		<div class="table-responsive">
			<table class="table table-condensed bg-gray">
				<thead>
					<tr class="bg-green">
						<th>SKU</th>
		                <th><?php echo app('translator')->getFromJson('business.product'); ?></th>
		                <th><?php echo app('translator')->getFromJson('business.location'); ?></th>
		                <th><?php echo app('translator')->getFromJson('sale.unit_price'); ?></th>
		                <th><?php echo app('translator')->getFromJson('report.current_stock'); ?></th>
		                <th><?php echo app('translator')->getFromJson('lang_v1.total_stock_price'); ?></th>
		                <th><?php echo app('translator')->getFromJson('report.total_unit_sold'); ?></th>
		                <th><?php echo app('translator')->getFromJson('lang_v1.total_unit_transfered'); ?></th>
		                <th><?php echo app('translator')->getFromJson('lang_v1.total_unit_adjusted'); ?></th>
		            </tr>
	            </thead>
	            <tbody>
	            	<?php $__currentLoopData = $product_stock_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	            		<tr>
	            			<td><?php echo e($product->sku, false); ?></td>
	            			<td>
	            				<?php
	            				$name = $product->product;
			                    if ($product->type == 'variable') {
			                        $name .= ' - ' . $product->product_variation . '-' . $product->variation_name;
			                    }
			                    ?>
			                    <?php echo e($name, false); ?>

	            			</td>
	            			<td><?php echo e($product->location_name, false); ?></td>
	            			<td>
                        		<span class="display_currency"data-currency_symbol=true ><?php echo e($product->unit_price ?? 0, false); ?></span>
                        	</td>
	            			<td>
                        		<span data-is_quantity="true" class="display_currency"data-currency_symbol=false ><?php echo e($product->stock ?? 0, false); ?></span><?php echo e($product->unit, false); ?>

                        	</td>
                        	<td>
                        		<span class="display_currency"data-currency_symbol=true ><?php echo e($product->unit_price * $product->stock, false); ?></span>
                        	</td>
                        	<td>
                        		<span data-is_quantity="true" class="display_currency"data-currency_symbol=false ><?php echo e($product->total_sold ?? 0, false); ?></span><?php echo e($product->unit, false); ?>

                        	</td>
                        	<td>
                        		<span data-is_quantity="true" class="display_currency"data-currency_symbol=false ><?php echo e($product->total_transfered ?? 0, false); ?></span><?php echo e($product->unit, false); ?>

                        	</td>
                        	<td>
                        		<span data-is_quantity="true" class="display_currency"data-currency_symbol=false ><?php echo e($product->total_adjusted ?? 0, false); ?></span><?php echo e($product->unit, false); ?>

                        	</td>
	            		</tr>
	            	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	            </tbody>
	     	</table>
     	</div>
    </div>
</div>
<?php // print_r($ps) ?>


<div class="row">
	<div class="col-md-12">
		<div class="table-responsive">
			<table class="table table-condensed bg-gray">
				<thead>
					<tr class="bg-green">
						<th>Quantity</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Ref No</th>
                        <th>Lot Number</th>
                        <th>Location To</th>
                        <th>Location From</th>
		            </tr>
	            </thead>
	            <tbody>
	            	<?php $__currentLoopData = $ps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	            	
	            	<?php 
	            	$st='';
	            	if($product->type=="opening_stock" || $product->type=="purchase" || $product->type=="purchase_transfer"){
	            	    $st="style=background:green;color:white;";
	            	}else if($product->type=="stock_adjustment" || $product->type=="sell_transfer"){
	            	    $st="style=background:red;color:white;";
	            	}
	            	
	            	
	            	?>
	            	
	            	
	            		<tr <?php echo e($st, false); ?>>
	            			<td><?php echo e($product->quantity, false); ?></td>
	            		    <td><?php echo e(date('d-m-Y h:i A',strtotime($product->transaction_date)), false); ?></td>
	            		    <td><?php echo e($product->type, false); ?></td>
	            		    <td><?php echo e($product->ref_no, false); ?></td>
	            		    <td><?php echo e($product->lot_number, false); ?></td>
	            		    <td><?php echo e($product->from_location, false); ?></td>
	            		    <td><?php echo e($product->to_location, false); ?></td>
	            		</tr>
	            	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	            </tbody>
	     	</table>
     	</div>
    </div>
</div><?php /**PATH /home/fmsbill/public_html/offer-electronics.fmsbill.in/resources/views/product/partials/product_stock_details.blade.php ENDPATH**/ ?>